$root = Split-Path -Parent $MyInvocation.MyCommand.Path
$candidates = @(
  (Join-Path $root "build\tezzc.exe"),
  (Join-Path $root "bin\tezzc-windows-x64.exe"),
  (Join-Path $root "tezzc.exe")
)
$tezzc = $null
foreach ($candidate in $candidates) {
  if (Test-Path $candidate) {
    $tezzc = $candidate
    break
  }
}
if (-not $tezzc) {
  Write-Error "tezz: compiler not found (expected build\tezzc.exe or bin\tezzc-windows-x64.exe)."
  exit 1
}
$tool = Join-Path $root "tools\tezz.tn"
if (-not (Test-Path $tool)) {
  Write-Error "tezz: tools\tezz.tn not found next to launcher."
  exit 1
}
& $tezzc run $tool -- @args
exit $LASTEXITCODE
